#!/bin/bash
#
# Entry point for docker containers

set -e
set -x

# Configuration

connectionString='jdbc:sqlite:/adata/ameinias.db'
webRoot='/usr/local/ameinias/web'
listenPort='7076'

# -- Audio config: how will you link this to your audio output?
#
# If socat or similar is running on this port
# outputUri='udp://audiosink:7077'
#
# If you've mapped /dev/snd into the container and edited properties so 
# that it plays thorugh a local device, leave empty:
outputUri=${OUTPUT_URI:-''}

# ENV overrides: did you move the database? 

connectionString=${CONNECTION_STRING:-$connectionString}

# Pass configuration via java properties

if [ "$1" = 'ameinias' ]; then
    cd /usr/local/ameinias

    # Create / update database
    java \
        -cp 'ameinias.jar:lib/*' \
	-Dlogback.configurationFile=file:/usr/local/ameinias/logback.xml \
        byteheaven.tamjb.Server.CreateDatabase \
        "${connectionString}"

    exec java \
	-cp 'ameinias.jar:lib/*' \
	-Dlogback.configurationFile=file:/usr/local/ameinias/logback.xml \
        -Dameinias.connectionString=${connectionString} \
        -Dameinias.webRoot=${webRoot} \
        -Dameinias.listenPort=${listenPort} \
        -Dameinias.outputUri=${outputUri} \
	byteheaven.tamjb.Server.Main
fi

exec "$@"
