/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerEvent;
import org.simpleframework.http.core.FlushMonitor;
import org.simpleframework.http.core.Initiator;
import org.simpleframework.http.core.Monitor;
import org.simpleframework.http.core.RequestEntity;
import org.simpleframework.http.core.ResponseEntity;
import org.simpleframework.http.message.Entity;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.trace.Trace;

class Dispatcher
implements Runnable {
    private final Container container;
    private final Response response;
    private final Request request;
    private final Monitor monitor;
    private final Channel channel;
    private final Trace trace;

    public Dispatcher(Container container, Initiator reactor, Entity entity) {
        this.monitor = new FlushMonitor(reactor, entity);
        this.request = new RequestEntity(entity, this.monitor);
        this.response = new ResponseEntity(this.request, entity, this.monitor);
        this.channel = entity.getChannel();
        this.trace = this.channel.getTrace();
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.dispatch();
        }
        catch (Exception cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, cause);
        }
        finally {
            this.trace.trace((Object)ContainerEvent.DISPATCH_FINISHED);
        }
    }

    private void dispatch() throws Exception {
        try {
            this.trace.trace((Object)ContainerEvent.DISPATCH_REQUEST);
            this.container.handle(this.request, this.response);
        }
        catch (Throwable cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, cause);
            this.channel.close();
        }
    }
}

