-- 
-- Don't "AUTOINCREMENT" filekey because we want to reuse keys and fill
-- gaps in the numbering for better randomization.
--
CREATE TABLE file_info ( 
  filekey INTEGER PRIMARY KEY NOT NULL,
  file_path TEXT NOT NULL,
  artist TEXT NOT NULL,
  album TEXT NOT NULL, 
  title TEXT NOT NULL,
  track INTEGER NOT NULL,
  genre TEXT NOT NULL,
  length_seconds INTEGER NOT NULL,
  status TEXT NOT NULL,
  play_count INTEGER DEFAULT 0, 
  power_bass REAL DEFAULT 3.9, 
  power_mid REAL DEFAULT 3.75, 
  power_treble REAL DEFAULT 3.6
);

--
-- This is to speed up updates to "file is not missing" file scanning
--
CREATE INDEX file_info_filepath_ix
  ON file_info
  ( file_path );

CREATE TABLE users ( 
  id           INTEGER PRIMARY KEY NOT NULL,
  name         TEXT NOT NULL,
  password     TEXT NOT NULL,
  role         TEXT NOT NULL 
);

CREATE TABLE mood (
  id           INTEGER PRIMARY KEY NOT NULL,
  name         TEXT NOT NULL
);

CREATE TABLE song_suck ( 
  track_ref    INTEGER NOT NULL,
  user_id      INTEGER NOT NULL,
  value        INTEGER NOT NULL
);

--
-- Can only have one suck rating per user per song
--
CREATE UNIQUE INDEX song_suck_compound_ix
  ON song_suck
  ( user_id, track_ref );

--
-- mood is indexed
-- by (track + user + mood). Yeouch, that's a lot of indexing.
--
CREATE TABLE song_mood ( 
  track_ref    INTEGER NOT NULL,
  mood_id      INTEGER NOT NULL,
  user_id      INTEGER NOT NULL,
  value        INTEGER NOT NULL
);

CREATE UNIQUE INDEX song_mood_compound_ix
  ON song_mood 
  ( mood_id, user_id, track_ref )
;
        
--
-- Create and initialize the single-row Settings table.
--
CREATE TABLE settings ( 
  id           INTEGER PRIMARY KEY NOT NULL,
  mp3Root      TEXT NOT NULL,
  albumSegmentWeight INTEGER NOT NULL,
  albumSegmentMaxlen INTEGER NOT NULL,
  metadataFileName TEXT NOT NULL,
  desiredQueueSize   INTEGER NOT NULL,
  compression        INTEGER NOT NULL,
  attenuationThreshold REAL NOT NULL,
  attenuationMultiplier REAL NOT NULL,
  contributorTimeout INTEGER NOT NULL,
  maxFinishedPlaying INTEGER NOT NULL,
  streamingServerUrl TEXT NOT NULL,
  neverPlayThreshold INTEGER NOT NULL,
  alwaysPlayThreshold INTEGER NOT NULL
);

CREATE TABLE compression_settings (
  id           INTEGER PRIMARY KEY NOT NULL,
  name         TEXT NOT NULL,
  threshold    REAL NOT NULL,
  ratio        REAL NOT NULL,
  attack       REAL NOT NULL,
  decay        REAL NOT NULL,
  gain         REAL NOT NULL
);

--
-- All moods that are currently active
--
CREATE TABLE active_mood (
  mood_id INTEGER PRIMARY KEY NOT NULL
);

--
-- Backend state that we want to persist across a restart. A single-row table.
--
-- There should always be one row in this table which should not be deleted,
-- just updated.
--
CREATE TABLE jb_state (
  last_cat_id INTEGER NOT NULL
);

INSERT INTO jb_state
(
  last_cat_id
)
VALUES
(
  0
);

--
-- ** Insert defaults **
--

--
-- Create default compression settings
--
-- (multiinsert requires SQLite 3.7.11+)
--
INSERT INTO compression_settings (
  name,
  threshold,
  ratio,
  attack,
  decay,
  gain
)
VALUES 
(
  'Bypass',
  '0.0',
  '1.0',
  '0.0',
  '1.0',
  '0.0'
),
(
  'Clean Radio',
  '-45',
  '8',
  '2.3',
  '180',
  '26'
),
(
  'Default',
  '-30',
  '6',
  '10',
  '200',
  '10'
),
(
  'SQUASHed',
  '-45',
  '99',
  '0.5',
  '30',
  '26'
),
(
  'Super Slow 6',
  '-45',
  '6',
  '4',
  '500',
  '27'
)
;



-- 
-- Insert rowid of default compressor settings here
--
INSERT INTO settings (
  id,
  mp3Root,
  albumSegmentWeight,
  albumSegmentMaxlen,
  metadataFileName,
  desiredQueueSize,
  compression,
  attenuationThreshold,
  attenuationMultiplier,
  contributorTimeout,
  maxFinishedPlaying,
  streamingServerUrl,
  neverPlayThreshold,
  alwaysPlayThreshold
)
VALUES
(
  1,
  '/mp3',
  11,
  8,
  '',
  40,
  last_insert_rowid(),
  0.8,
  20,
  604800000,
  25,
  'http://example.com/example.m3u',
  9900,
  500
);

-- 
-- UserInfo.AdminId == 1
-- Role.CAT == 'CAT'
-- 12345 == the password on my luggage
--
INSERT INTO users
( name, id, role, password )
VALUES
(
  'admin',
  '1',
  'CAT',
  '12345'
);

-- 
-- GUEST == 2
--
INSERT INTO users
( name, id, role, password )
VALUES
(
  'Guest',
  '2',
  'NOBODY',
  '12345'
);


INSERT INTO mood
( name )
VALUES
(
  'I Feel Normal'
);
