/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import org.simpleframework.http.message.BodyConsumer;
import org.simpleframework.http.message.Consumer;
import org.simpleframework.http.message.PartFactory;
import org.simpleframework.http.message.PartHeaderConsumer;
import org.simpleframework.http.message.PartSeries;
import org.simpleframework.http.message.SegmentConsumer;
import org.simpleframework.transport.Cursor;
import org.simpleframework.util.buffer.Allocator;

class PartConsumer
implements Consumer {
    private SegmentConsumer header;
    private BodyConsumer body;
    private PartFactory factory;
    private PartSeries series;
    private Consumer current;
    private byte[] terminal;

    public PartConsumer(Allocator allocator, PartSeries series, byte[] terminal, long length) {
        this.header = new PartHeaderConsumer(allocator);
        this.factory = new PartFactory(allocator, this.header, length);
        this.terminal = terminal;
        this.current = this.header;
        this.series = series;
    }

    private BodyConsumer getConsumer() {
        return this.factory.getInstance(this.series, this.terminal);
    }

    public void consume(Cursor cursor) throws IOException {
        while (cursor.isReady()) {
            if (this.header.isFinished()) {
                if (this.body == null) {
                    this.body = this.getConsumer();
                    this.current = this.body;
                } else if (this.body.isFinished()) break;
            }
            this.current.consume(cursor);
        }
    }

    public boolean isFinished() {
        if (this.body != null) {
            return this.body.isFinished();
        }
        return false;
    }
}

