/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.parse;

import org.simpleframework.http.ContentType;
import org.simpleframework.util.KeyMap;
import org.simpleframework.util.parse.ParseBuffer;
import org.simpleframework.util.parse.Parser;

public class ContentTypeParser
extends Parser
implements ContentType {
    private ParseBuffer secondary = new ParseBuffer();
    private ParseBuffer primary = new ParseBuffer();
    private ParseBuffer charset = new ParseBuffer();
    private ParseBuffer type;
    private ParseBuffer name;
    private ParseBuffer value = new ParseBuffer();
    private KeyMap<String> map;

    public ContentTypeParser() {
        this.type = new ParseBuffer();
        this.name = new ParseBuffer();
        this.map = new KeyMap();
    }

    public ContentTypeParser(String header) {
        this();
        this.parse(header);
    }

    public String getType() {
        return this.type.toString();
    }

    public void setPrimary(String value) {
        this.type.reset(value);
        this.type.append('/');
        this.type.append(this.secondary);
        this.primary.reset(value);
    }

    public String getPrimary() {
        return this.primary.toString();
    }

    public void setSecondary(String value) {
        this.type.reset(this.primary);
        this.type.append('/');
        this.type.append(value);
        this.secondary.reset(value);
    }

    public String getSecondary() {
        return this.secondary.toString();
    }

    public void setCharset(String enc) {
        this.charset.reset(enc);
    }

    public String getCharset() {
        return this.charset.toString();
    }

    public String getParameter(String name) {
        return (String)this.map.get(name);
    }

    public void setParameter(String name, String value) {
        this.map.put(name, value);
    }

    protected void init() {
        if (this.count > 0) {
            this.pack();
        }
        this.clear();
    }

    private void clear() {
        this.primary.clear();
        this.secondary.clear();
        this.charset.clear();
        this.name.clear();
        this.value.clear();
        this.type.clear();
        this.map.clear();
        this.off = 0;
    }

    protected void parse() {
        this.primary();
        ++this.off;
        this.secondary();
        this.parameters();
    }

    private void pack() {
        char old = this.buf[0];
        int len = this.count;
        int seek = 0;
        int pos = 0;
        block0: while (seek < len) {
            char ch;
            if ((ch = this.buf[seek++]) == '\"' && old != '\\') {
                this.buf[pos++] = ch;
                while (seek < len) {
                    old = this.buf[seek - 1];
                    ch = this.buf[seek++];
                    this.buf[pos++] = ch;
                    if (ch != '\"' || old == '\\') continue;
                    continue block0;
                }
                continue;
            }
            if (this.space(ch)) continue;
            old = this.buf[seek - 1];
            this.buf[pos++] = old;
        }
        this.count = pos;
    }

    private void primary() {
        while (this.off < this.count) {
            if (this.buf[this.off] == '/') {
                this.type.append('/');
                break;
            }
            this.type.append(this.buf[this.off]);
            this.primary.append(this.buf[this.off]);
            ++this.off;
        }
    }

    private void secondary() {
        while (this.off < this.count && this.buf[this.off] != ';') {
            this.type.append(this.buf[this.off]);
            this.secondary.append(this.buf[this.off]);
            ++this.off;
        }
    }

    private void parameters() {
        while (this.skip(";")) {
            if (this.skip("charset=")) {
                this.charset();
                break;
            }
            this.parameter();
            this.insert();
        }
    }

    private void insert() {
        this.insert(this.name, this.value);
        this.name.clear();
        this.value.clear();
    }

    private void insert(ParseBuffer name, ParseBuffer value) {
        this.map.put(name.toString(), value.toString());
    }

    private void parameter() {
        this.name();
        ++this.off;
        this.value();
    }

    private void name() {
        while (this.off < this.count && this.buf[this.off] != '=') {
            this.name.append(this.buf[this.off]);
            ++this.off;
        }
    }

    private void value() {
        if (this.quote(this.buf[this.off])) {
            ++this.off;
            while (!(this.off >= this.count || this.quote(this.buf[this.off]) && this.buf[++this.off - 2] != '\\')) {
                this.value.append(this.buf[this.off++]);
            }
        } else {
            while (this.off < this.count && this.buf[this.off] != ';') {
                this.value.append(this.buf[this.off]);
                ++this.off;
            }
        }
    }

    private boolean quote(char ch) {
        return ch == '\'' || ch == '\"';
    }

    private void charset() {
        if (this.buf[this.off] == '\"') {
            this.charset.append('\"');
            ++this.off;
            while (this.off < this.count) {
                this.charset.append(this.buf[this.off]);
                if (this.buf[this.off++] != '\"' || this.buf[this.off - 2] == '\\') continue;
                break;
            }
        } else {
            while (this.off < this.count && this.buf[this.off] != ';') {
                this.charset.append(this.buf[this.off]);
                ++this.off;
            }
        }
    }

    private String encode() {
        StringBuilder text = new StringBuilder();
        if (this.primary != null) {
            text.append(this.primary);
            text.append("/");
            text.append(this.secondary);
        }
        if (this.charset.length() > 0) {
            text.append("; charset=");
            text.append(this.charset);
        }
        return this.encode(text);
    }

    private String encode(StringBuilder text) {
        for (String name : this.map) {
            String value = (String)this.map.get(name);
            text.append("; ");
            text.append(name);
            if (value == null) continue;
            text.append("=");
            text.append(value);
        }
        return text.toString();
    }

    public String toString() {
        return this.encode();
    }
}

