#!/bin/bash
#
# Entry point for docker containers

set -e
set -x

# Configuration

connectionString='jdbc:h2:/adata/ameinias'
webRoot='/usr/local/ameinias/web'
listenPort='7076'

# Assuming socat or similar is running on this port
outputUri='udp://audiosink:7077'

# ENV overrides: did you move the database? 

connectionString=${CONNECTION_STRING:-$connectionString}

# Pass configuration via java properties

if [ "$1" = 'ameinias' ]; then
    cd /usr/local/ameinias

    # DB_CLOSE_ON_EXIT=FALSE results in mysterious silent failure to create tables
    # which may be due to the failure to do an explicit SHUTDOWN?

    # Create database if the meta table does not exist
    /usr/bin/java \
        -cp 'ameinias.jar:lib/*' \
	-Dlog4j.configuration=file:log4j.properties \
        byteheaven.tamjb.Server.CreateDatabase \
        "${connectionString}"

    exec /usr/bin/java \
	-cp 'ameinias.jar:lib/*' \
	-Dlog4j.configuration=file:log4j.properties \
        -Dameinias.connectionString=${connectionString}";TRACE_LEVEL_FILE=4;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE" \
        -Dameinias.webRoot=${webRoot} \
        -Dameinias.listenPort=${listenPort} \
        -Dameinias.outputUri=${outputUri} \
	byteheaven.tamjb.Server.Main
fi

exec "$@"
