/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.event.LifecycleEventManager;
import org.apache.openjpa.jdbc.kernel.InstanceResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PagingResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.ProjectionResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.exps.Abs;
import org.apache.openjpa.jdbc.kernel.exps.Args;
import org.apache.openjpa.jdbc.kernel.exps.Concat;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.GetColumn;
import org.apache.openjpa.jdbc.kernel.exps.IndexOf;
import org.apache.openjpa.jdbc.kernel.exps.JDBCExpressionFactory;
import org.apache.openjpa.jdbc.kernel.exps.JDBCStringContains;
import org.apache.openjpa.jdbc.kernel.exps.JDBCWildcardMatch;
import org.apache.openjpa.jdbc.kernel.exps.Math;
import org.apache.openjpa.jdbc.kernel.exps.PCPath;
import org.apache.openjpa.jdbc.kernel.exps.QueryExpressionsState;
import org.apache.openjpa.jdbc.kernel.exps.SQLEmbed;
import org.apache.openjpa.jdbc.kernel.exps.SQLExpression;
import org.apache.openjpa.jdbc.kernel.exps.SQLValue;
import org.apache.openjpa.jdbc.kernel.exps.Sqrt;
import org.apache.openjpa.jdbc.kernel.exps.StringLength;
import org.apache.openjpa.jdbc.kernel.exps.Substring;
import org.apache.openjpa.jdbc.kernel.exps.ToLowerCase;
import org.apache.openjpa.jdbc.kernel.exps.ToUpperCase;
import org.apache.openjpa.jdbc.kernel.exps.Trim;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.NoneDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.VerticalClassStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.PostgresDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.jdbc.sql.SelectExecutor;
import org.apache.openjpa.jdbc.sql.SelectImpl;
import org.apache.openjpa.jdbc.sql.Union;
import org.apache.openjpa.kernel.ExpressionStoreQuery;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.OrderingMergedResultObjectProvider;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.Constant;
import org.apache.openjpa.kernel.exps.Context;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.kernel.exps.Literal;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.lib.rop.MergedResultObjectProvider;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;

public class JDBCStoreQuery
extends ExpressionStoreQuery {
    private static final Table INVALID = new Table();
    private static final Map _listeners = new HashMap();
    private final transient JDBCStore _store;
    private static ThreadLocalContext localContext;

    public JDBCStoreQuery(JDBCStore store, ExpressionParser parser) {
        super(parser);
        this._store = store;
    }

    public JDBCStore getStore() {
        return this._store;
    }

    @Override
    public FilterListener getFilterListener(String tag) {
        return (FilterListener)_listeners.get(tag);
    }

    @Override
    public Object newCompilationKey() {
        JDBCFetchConfiguration fetch = (JDBCFetchConfiguration)this.ctx.getFetchConfiguration();
        return fetch.getJoinSyntax();
    }

    @Override
    public boolean supportsDataStoreExecution() {
        return true;
    }

    @Override
    protected ClassMetaData[] getIndependentExpressionCandidates(ClassMetaData meta, boolean subclasses) {
        if (!subclasses) {
            return new ClassMapping[]{(ClassMapping)meta};
        }
        return ((ClassMapping)meta).getIndependentAssignableMappings();
    }

    @Override
    protected ExpressionFactory getExpressionFactory(ClassMetaData meta) {
        JDBCExpressionFactory factory = new JDBCExpressionFactory((ClassMapping)meta);
        if (this._store.getDBDictionary() instanceof PostgresDictionary) {
            factory.setBooleanLiteralAsNumeric(false);
        }
        return factory;
    }

    @Override
    protected ResultObjectProvider executeQuery(StoreQuery.Executor ex, ClassMetaData base, ClassMetaData[] metas, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] exps, Object[] params, StoreQuery.Range range) {
        boolean unionable;
        Context[] ctxs = new Context[exps.length];
        for (int i = 0; i < exps.length; ++i) {
            ctxs[i] = exps[i].ctx();
        }
        localContext.set(JDBCStoreQuery.clone(ctxs, null));
        if (metas.length > 1 && exps[0].isAggregate()) {
            throw new UserException(Localizer.forPackage(JDBCStoreQuery.class).get("mult-mapping-aggregate", Arrays.asList(metas)));
        }
        ClassMapping[] mappings = (ClassMapping[])metas;
        JDBCFetchConfiguration fetch = (JDBCFetchConfiguration)this.ctx.getFetchConfiguration();
        if (exps[0].fetchPaths != null) {
            fetch.addFields(Arrays.asList(exps[0].fetchPaths));
            fetch.addJoins(Arrays.asList(exps[0].fetchPaths));
        }
        if (exps[0].fetchInnerPaths != null) {
            fetch.addFetchInnerJoins(Arrays.asList(exps[0].fetchInnerPaths));
        }
        int eager = this.calculateEagerMode(exps[0], range.start, range.end);
        int subclassMode = fetch.getSubclassFetchMode((ClassMapping)base);
        DBDictionary dict = this._store.getDBDictionary();
        long start = mappings.length == 1 && dict.supportsSelectStartIndex ? range.start : 0L;
        long end = dict.supportsSelectEndIndex ? range.end : Long.MAX_VALUE;
        QueryExpressionsState[] states = new QueryExpressionsState[exps.length];
        for (int i = 0; i < states.length; ++i) {
            states[i] = new QueryExpressionsState();
            exps[i].state = states[i];
        }
        ArrayList sels = new ArrayList(mappings.length);
        ArrayList selMappings = new ArrayList(mappings.length);
        BitSet subclassBits = new BitSet();
        BitSet nextBits = new BitSet();
        ExpContext ctx = new ExpContext(this._store, params, fetch);
        boolean bl = unionable = this.createWhereSelects(sels, mappings, selMappings, subclasses, subclassBits, nextBits, facts, exps, states, ctx, subclassMode) && subclassMode == 1 && start == 0L && end == Long.MAX_VALUE;
        if (sels.size() > 1) {
            start = 0L;
        }
        boolean lrs = range.lrs || fetch.getFetchBatchSize() >= 0 && (start != range.start || end != range.end);
        ResultObjectProvider[] rops = null;
        ResultObjectProvider rop = null;
        if (unionable) {
            Union union = this._store.getSQLFactory().newUnion(sels.toArray(new Select[sels.size()]));
            BitSet[] paged = this.populateUnion(union, mappings, subclasses, facts, exps, states, ctx, lrs, eager, start, end);
            union.setLRS(lrs);
            rop = this.executeUnion(union, mappings, exps, states, ctx, paged);
        } else {
            if (sels.size() > 1) {
                rops = new ResultObjectProvider[sels.size()];
            }
            int idx = 0;
            for (int i = 0; i < sels.size(); ++i) {
                Select sel = (Select)sels.get(i);
                BitSet paged = this.populateSelect(sel, (ClassMapping)selMappings.get(i), subclassBits.get(i), (JDBCExpressionFactory)facts[idx], exps[idx], states[idx], ctx, lrs, eager, start, end);
                rop = this.executeSelect(sel, (ClassMapping)selMappings.get(i), exps[idx], states[idx], ctx, paged, start, end);
                if (rops != null) {
                    rops[i] = rop;
                }
                if (!nextBits.get(i)) continue;
                ++idx;
            }
        }
        if (rops != null) {
            rop = exps[0].ascending.length == 0 ? new MergedResultObjectProvider(rops) : new OrderingMergedResultObjectProvider(rops, exps[0].ascending, ex, (StoreQuery)this, params);
        }
        if (rops != null && range.end != Long.MAX_VALUE || start != range.start || end != range.end) {
            rop = new RangeResultObjectProvider(rop, range.start, range.end);
        }
        localContext.remove();
        return rop;
    }

    private BitSet[] populateUnion(Union union, final ClassMapping[] mappings, final boolean subclasses, final ExpressionFactory[] facts, final QueryExpressions[] exps, final QueryExpressionsState[] states, final ExpContext ctx, final boolean lrs, final int eager, final long start, final long end) {
        final BitSet[] paged = exps[0].projections.length > 0 ? null : new BitSet[mappings.length];
        union.select(new Union.Selector(){

            @Override
            public void select(Select sel, int idx) {
                BitSet bits = JDBCStoreQuery.this.populateSelect(sel, mappings[idx], subclasses, (JDBCExpressionFactory)facts[idx], exps[idx], states[idx], ctx, lrs, eager, start, end);
                if (paged != null) {
                    paged[idx] = bits;
                }
            }
        });
        return paged;
    }

    private BitSet populateSelect(Select sel, ClassMapping mapping, boolean subclasses, JDBCExpressionFactory fact, QueryExpressions exps, QueryExpressionsState state, ExpContext ctx, boolean lrs, int eager, long start, long end) {
        sel.setLRS(lrs);
        sel.setRange(start, end);
        BitSet paged = null;
        if (exps.projections.length == 0 && (paged = PagingResultObjectProvider.getPagedFields(sel, mapping, this._store, ctx.fetch, eager, end - start)) != null) {
            eager = 1;
        }
        fact.getSelectConstructor().select(sel, ctx, mapping, subclasses, exps, state, eager);
        return paged;
    }

    private ResultObjectProvider executeUnion(Union union, ClassMapping[] mappings, QueryExpressions[] exps, QueryExpressionsState[] states, ExpContext ctx, BitSet[] paged) {
        if (exps[0].projections.length > 0) {
            return new ProjectionResultObjectProvider((SelectExecutor)union, exps, states, ctx);
        }
        if (paged != null) {
            for (int i = 0; i < paged.length; ++i) {
                if (paged[i] == null) continue;
                return new PagingResultObjectProvider((SelectExecutor)union, mappings, this._store, ctx.fetch, paged, Long.MAX_VALUE);
            }
        }
        return new InstanceResultObjectProvider(union, mappings[0], this._store, ctx.fetch);
    }

    private ResultObjectProvider executeSelect(Select sel, ClassMapping mapping, QueryExpressions exps, QueryExpressionsState state, ExpContext ctx, BitSet paged, long start, long end) {
        if (exps.projections.length > 0) {
            return new ProjectionResultObjectProvider((SelectExecutor)sel, exps, state, ctx);
        }
        if (paged != null) {
            return new PagingResultObjectProvider((SelectExecutor)sel, mapping, this._store, ctx.fetch, paged, end - start);
        }
        return new InstanceResultObjectProvider(sel, mapping, this._store, ctx.fetch);
    }

    private boolean createWhereSelects(List sels, ClassMapping[] mappings, List selMappings, boolean subclasses, BitSet subclassBits, BitSet nextBits, ExpressionFactory[] facts, QueryExpressions[] exps, QueryExpressionsState[] states, ExpContext ctx, int subclassMode) {
        Number optHint = (Number)ctx.fetch.getHint("openjpa.hint.OptimizeResultCount");
        boolean unionable = true;
        for (int i = 0; i < mappings.length; ++i) {
            int j;
            ClassMapping[] verts = this.getVerticalMappings(mappings[i], subclasses, exps[i], subclassMode);
            if (verts.length == 1 && subclasses) {
                subclassBits.set(sels.size());
            }
            Discriminator disc = mappings[i].getDiscriminator();
            if (mappings.length > 1 && disc != null && disc.getColumns().length == 0 && disc.getStrategy() instanceof NoneDiscriminatorStrategy) {
                ctx.tpcMeta = mappings[i];
            }
            Select sel = ((JDBCExpressionFactory)facts[i]).getSelectConstructor().evaluate(ctx, null, null, exps[i], states[i]);
            if (optHint != null) {
                sel.setExpectedResultCount(optHint.intValue(), true);
            } else if (this.ctx.isUnique()) {
                sel.setExpectedResultCount(1, false);
            }
            List selectFrom = this.getJoinedTableMeta(sel);
            int size = 0;
            if (selectFrom != null) {
                size = selectFrom.size();
                for (j = 0; j < size; ++j) {
                    ClassMapping vert = (ClassMapping)selectFrom.get(j);
                    selMappings.add(vert);
                    if (j == size - 1) {
                        nextBits.set(sels.size());
                        sel.select(vert.getPrimaryKeyColumns(), null);
                        sels.add(sel);
                        continue;
                    }
                    SelectImpl selClone = (SelectImpl)sel.fullClone(1);
                    selClone.select(vert.getPrimaryKeyColumns(), null);
                    sels.add(selClone);
                }
            } else {
                for (j = 0; j < verts.length; ++j) {
                    selMappings.add(verts[j]);
                    if (j == verts.length - 1) {
                        nextBits.set(sels.size());
                        sels.add(sel);
                        continue;
                    }
                    sels.add(sel.fullClone(1));
                }
            }
            if (verts.length <= 1 && size <= 1 && sel.getFromSelect() == null) continue;
            unionable = false;
        }
        return unionable;
    }

    private List getJoinedTableMeta(Select sel) {
        List selectFrom = sel.getJoinedTableClassMeta();
        List exSelectFrom = sel.getExcludedJoinedTableClassMeta();
        if (exSelectFrom == null) {
            return selectFrom;
        }
        if (selectFrom == null) {
            return null;
        }
        int size = selectFrom.size();
        ArrayList retList = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object obj = selectFrom.get(i);
            if (exSelectFrom.contains(obj)) continue;
            retList.add(obj);
        }
        return retList;
    }

    private ClassMapping[] getVerticalMappings(ClassMapping mapping, boolean subclasses, QueryExpressions exps, int subclassMode) {
        if (!subclasses || exps.projections.length > 0) {
            return new ClassMapping[]{mapping};
        }
        if (subclassMode != 2 || !JDBCStoreQuery.hasVerticalSubclasses(mapping)) {
            return new ClassMapping[]{mapping};
        }
        ArrayList subs = new ArrayList(4);
        this.addSubclasses(mapping, subs);
        return subs.toArray(new ClassMapping[subs.size()]);
    }

    private void addSubclasses(ClassMapping mapping, Collection subs) {
        subs.add(mapping);
        if (!JDBCStoreQuery.hasVerticalSubclasses(mapping)) {
            return;
        }
        ClassMapping[] subMappings = mapping.getJoinablePCSubclassMappings();
        for (int i = 0; i < subMappings.length; ++i) {
            if (subMappings[i].getJoinablePCSuperclassMapping() != mapping) continue;
            this.addSubclasses(subMappings[i], subs);
        }
    }

    private static boolean hasVerticalSubclasses(ClassMapping mapping) {
        ClassMapping[] subs = mapping.getJoinablePCSubclassMappings();
        for (int i = 0; i < subs.length; ++i) {
            if (!(subs[i].getStrategy() instanceof VerticalClassStrategy)) continue;
            return true;
        }
        return false;
    }

    private int calculateEagerMode(QueryExpressions exps, long start, long end) {
        if (exps.projections.length > 0 || start >= end) {
            return 0;
        }
        if (end - start == 1L || this.ctx.isUnique()) {
            return 1;
        }
        return 2;
    }

    @Override
    protected Number executeDelete(StoreQuery.Executor ex, ClassMetaData base, ClassMetaData[] metas, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] exps, Object[] params) {
        return this.executeBulkOperation(metas, subclasses, facts, exps, params, null);
    }

    @Override
    protected Number executeUpdate(StoreQuery.Executor ex, ClassMetaData base, ClassMetaData[] metas, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] exps, Object[] params) {
        return this.executeBulkOperation(metas, subclasses, facts, exps, params, exps[0].updates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Number executeBulkOperation(ClassMetaData[] metas, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] exps, Object[] params, Map updates) {
        Context[] ctxs = new Context[exps.length];
        for (int i = 0; i < exps.length; ++i) {
            ctxs[i] = exps[i].ctx();
        }
        localContext.set(JDBCStoreQuery.clone(ctxs, null));
        ClassMapping[] mappings = (ClassMapping[])metas;
        boolean isUpdate = updates != null && updates.size() > 0;
        for (int i = 0; i < mappings.length; ++i) {
            LifecycleEventManager mgr;
            if (!this.isSingleTableMapping(mappings[i], subclasses) && !isUpdate) {
                return null;
            }
            if (isUpdate || !(mgr = this.ctx.getStoreContext().getBroker().getLifecycleEventManager()).hasDeleteListeners(null, mappings[i])) continue;
            return null;
        }
        JDBCFetchConfiguration fetch = (JDBCFetchConfiguration)this.ctx.getFetchConfiguration();
        ExpContext ctx = new ExpContext(this._store, params, fetch);
        DBDictionary dict = this._store.getDBDictionary();
        QueryExpressionsState[] state = new QueryExpressionsState[exps.length];
        for (int i = 0; i < state.length; ++i) {
            state[i] = new QueryExpressionsState();
        }
        SQLBuffer[] sql2 = new SQLBuffer[mappings.length];
        for (int i = 0; i < mappings.length; ++i) {
            JDBCExpressionFactory jdbcFactory = (JDBCExpressionFactory)facts[i];
            Select sel = jdbcFactory.getSelectConstructor().evaluate(ctx, null, null, exps[i], state[i]);
            jdbcFactory.getSelectConstructor().select(sel, ctx, mappings[i], subclasses, exps[i], state[i], 0);
            sql2[i] = !isUpdate ? dict.toDelete(mappings[i], sel, params) : dict.toUpdate(mappings[i], sel, this._store, params, updates);
            if (sql2[i] != null) continue;
            return null;
        }
        this._store.getContext().beginStore();
        Connection conn = this._store.getConnection();
        long count = 0L;
        try {
            for (int i = 0; i < sql2.length; ++i) {
                PreparedStatement stmnt = null;
                try {
                    stmnt = this.prepareStatement(conn, sql2[i]);
                    dict.setTimeouts(stmnt, fetch, true);
                    count += (long)this.executeUpdate(conn, stmnt, sql2[i], isUpdate);
                    continue;
                }
                catch (SQLException se) {
                    throw SQLExceptions.getStore(se, sql2[i].getSQL(), this._store.getDBDictionary());
                }
                finally {
                    if (stmnt != null) {
                        try {
                            stmnt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        }
        finally {
            try {
                if (conn.getAutoCommit()) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        localContext.remove();
        return count;
    }

    private boolean isSingleTableMapping(ClassMapping mapping, boolean subclasses) {
        ClassMapping root = mapping;
        while (root.getJoinablePCSuperclassMapping() != null) {
            root = root.getJoinablePCSuperclassMapping();
        }
        if (JDBCStoreQuery.hasVerticalSubclasses(root)) {
            return false;
        }
        Table table = this.getTable(mapping.getFieldMappings(), null);
        if (table == INVALID) {
            return false;
        }
        if (subclasses) {
            ClassMapping[] subs = mapping.getJoinablePCSubclassMappings();
            for (int i = 0; subs != null && i < subs.length; ++i) {
                table = this.getTable(subs[i].getDefinedFieldMappings(), table);
                if (table != INVALID) continue;
                return false;
            }
        }
        return true;
    }

    private Table getTable(FieldMapping[] fields, Table table) {
        for (int i = 0; i < fields.length && (table = this.getTable(fields[i], table)) != INVALID; ++i) {
        }
        return table;
    }

    private Table getTable(FieldMapping fm, Table table) {
        if (fm.getCascadeDelete() != 0 && !fm.isEmbeddedPC()) {
            return INVALID;
        }
        Column[] columns = fm.getColumns();
        for (int i = 0; columns != null && i < columns.length; ++i) {
            if (table == null) {
                table = columns[i].getTable();
                continue;
            }
            if (table == columns[i].getTable()) continue;
            return INVALID;
        }
        if (fm.isBidirectionalJoinTableMappingOwner()) {
            return INVALID;
        }
        return table;
    }

    protected Number executeUpdate(ClassMetaData base, ClassMetaData[] metas, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] parsed, Object[] params) {
        return null;
    }

    @Override
    protected String[] getDataStoreActions(ClassMetaData base, ClassMetaData[] metas, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] exps, Object[] params, StoreQuery.Range range) {
        int i;
        boolean unionable;
        Context[] ctxs = new Context[exps.length];
        for (int i2 = 0; i2 < exps.length; ++i2) {
            ctxs[i2] = exps[i2].ctx();
        }
        localContext.set(JDBCStoreQuery.clone(ctxs, null));
        ClassMapping[] mappings = (ClassMapping[])metas;
        JDBCFetchConfiguration fetch = (JDBCFetchConfiguration)this.ctx.getFetchConfiguration();
        if (exps[0].fetchPaths != null) {
            fetch.addFields(Arrays.asList(exps[0].fetchPaths));
            fetch.addJoins(Arrays.asList(exps[0].fetchPaths));
        }
        if (exps[0].fetchInnerPaths != null) {
            fetch.addFetchInnerJoins(Arrays.asList(exps[0].fetchInnerPaths));
        }
        int eager = this.calculateEagerMode(exps[0], range.start, range.end);
        eager = java.lang.Math.min(eager, 1);
        int subclassMode = fetch.getSubclassFetchMode((ClassMapping)base);
        DBDictionary dict = this._store.getDBDictionary();
        long start = mappings.length == 1 && dict.supportsSelectStartIndex ? range.start : 0L;
        long end = dict.supportsSelectEndIndex ? range.end : Long.MAX_VALUE;
        QueryExpressionsState[] states = new QueryExpressionsState[exps.length];
        for (int i3 = 0; i3 < states.length; ++i3) {
            states[i3] = new QueryExpressionsState();
        }
        List<Object> sels = new ArrayList(mappings.length);
        ArrayList selMappings = new ArrayList(mappings.length);
        BitSet subclassBits = new BitSet();
        BitSet nextBits = new BitSet();
        ExpContext ctx = new ExpContext(this._store, params, fetch);
        boolean bl = unionable = this.createWhereSelects(sels, mappings, selMappings, subclasses, subclassBits, nextBits, facts, exps, states, ctx, subclassMode) && subclassMode == 1;
        if (sels.size() > 1) {
            start = 0L;
        }
        if (unionable) {
            Union union = this._store.getSQLFactory().newUnion(sels.toArray(new Select[sels.size()]));
            this.populateUnion(union, mappings, subclasses, facts, exps, states, ctx, false, eager, start, end);
            if (union.isUnion()) {
                return new String[]{union.toSelect(false, fetch).getSQL(true)};
            }
            sels = Arrays.asList(union.getSelects());
        } else {
            int idx = 0;
            for (i = 0; i < sels.size(); ++i) {
                Select sel = (Select)sels.get(i);
                this.populateSelect(sel, (ClassMapping)selMappings.get(i), subclassBits.get(i), (JDBCExpressionFactory)facts[idx], exps[idx], states[idx], ctx, false, eager, start, end);
                if (!nextBits.get(i)) continue;
                ++idx;
            }
        }
        String[] sql2 = new String[sels.size()];
        for (i = 0; i < sels.size(); ++i) {
            sql2[i] = ((Select)sels.get(i)).toSelect(false, fetch).getSQL(true);
        }
        localContext.remove();
        return sql2;
    }

    protected int executeUpdate(Connection conn, PreparedStatement stmnt, SQLBuffer sqlBuf, boolean isUpdate) throws SQLException {
        return stmnt.executeUpdate();
    }

    protected PreparedStatement prepareStatement(Connection conn, SQLBuffer sql2) throws SQLException {
        return sql2.prepareStatement(conn);
    }

    @Override
    public Object evaluate(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        int id = 0;
        if (!(value instanceof Val)) {
            throw new UnsupportedException();
        }
        id = ((Val)value).getId();
        switch (id) {
            case 1: {
                return this.handleMathVal(value, ob, params, sm);
            }
            case 2: {
                return this.handleConcatVal(value, ob, params, sm);
            }
            case 3: {
                return this.handleSubstringVal(value, ob, params, sm);
            }
            case 9: {
                return this.handleArgsVal(value, ob, params, sm);
            }
            case 5: {
                return this.handleLowerVal(value, ob, params, sm);
            }
            case 4: {
                return this.handleUpperVal(value, ob, params, sm);
            }
            case 7: {
                return this.handleLengthVal(value, ob, params, sm);
            }
            case 6: {
                return this.handleTrimVal(value, ob, params, sm);
            }
            case 10: {
                return this.handleIndexOfVal(value, ob, params, sm);
            }
            case 11: {
                return this.handleAbsVal(value, ob, params, sm);
            }
            case 12: {
                return this.handleSqrtVal(value, ob, params, sm);
            }
        }
        throw new UnsupportedException();
    }

    private Object handleMathVal(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        Math mathVal = (Math)value;
        Val value1 = mathVal.getVal1();
        Object val1 = this.getValue(value1, ob, params, sm);
        Class c1 = value1.getType();
        Val value2 = mathVal.getVal2();
        Object val2 = this.getValue(value2, ob, params, sm);
        Class c2 = value2.getType();
        String op = mathVal.getOperation();
        if (op.equals("+")) {
            return Filters.add(val1, c1, val2, c2);
        }
        if (op.equals("-")) {
            return Filters.subtract(val1, c1, val2, c2);
        }
        if (op.equals("*")) {
            return Filters.multiply(val1, c1, val2, c2);
        }
        if (op.equals("/")) {
            return Filters.divide(val1, c1, val2, c2);
        }
        if (op.equals("MOD")) {
            return Filters.mod(val1, c1, val2, c2);
        }
        throw new UnsupportedException();
    }

    private Object handleConcatVal(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        Concat concatVal = (Concat)value;
        Val value1 = concatVal.getVal1();
        Object val1 = this.getValue(value1, ob, params, sm);
        Val value2 = concatVal.getVal2();
        Object val2 = this.getValue(value2, ob, params, sm);
        return new StringBuilder(100).append(val1).append(val2).toString();
    }

    private Object handleSubstringVal(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        Substring substrVal = (Substring)value;
        Val value1 = substrVal.getVal1();
        String val1 = (String)this.getValue(value1, ob, params, sm);
        Val value2 = substrVal.getVal2();
        Object val2 = this.getValue(value2, ob, params, sm);
        Value[] valAry2 = (Value[])val2;
        Object arg1 = this.getValue(valAry2[0], ob, params, sm);
        Object arg2 = this.getValue(valAry2[1], ob, params, sm);
        int startIdx = ((Long)arg1).intValue();
        int length = ((Long)arg2).intValue();
        int endIdx = startIdx + length;
        return val1.substring(startIdx, endIdx);
    }

    private Object handleArgsVal(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        Args argsVal = (Args)value;
        return argsVal.getValues();
    }

    private Object handleLowerVal(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        ToLowerCase lowerVal = (ToLowerCase)value;
        Val val = lowerVal.getValue();
        return ((String)this.getValue(val, ob, params, sm)).toLowerCase();
    }

    private Object handleUpperVal(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        ToUpperCase upperVal = (ToUpperCase)value;
        Val val = upperVal.getValue();
        return ((String)this.getValue(val, ob, params, sm)).toUpperCase();
    }

    private Object handleLengthVal(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        StringLength strLenVal = (StringLength)value;
        Val val = strLenVal.getValue();
        return ((String)this.getValue(val, ob, params, sm)).length();
    }

    private Object handleTrimVal(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        Trim trimVal = (Trim)value;
        Val val = trimVal.getVal();
        String valStr = (String)this.getValue(val, ob, params, sm);
        Val trimChar = trimVal.getTrimChar();
        char trimCharObj = ((String)this.getValue(trimChar, ob, params, sm)).charAt(0);
        Boolean where = trimVal.getWhere();
        if (where == null) {
            return this.trimLeading(this.trimTrailing(valStr, trimCharObj), trimCharObj);
        }
        if (where.booleanValue()) {
            return this.trimLeading(valStr, trimCharObj);
        }
        return this.trimTrailing(valStr, trimCharObj);
    }

    private String trimLeading(String value, char trimChar) {
        int startIdx = 0;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            if (value.charAt(i) == trimChar) continue;
            startIdx = i;
            break;
        }
        return value.substring(startIdx);
    }

    private String trimTrailing(String value, char trimChar) {
        int endIdx = 0;
        int len = value.length();
        for (int i = len - 1; i >= 0; --i) {
            if (value.charAt(i) == trimChar) continue;
            endIdx = i;
            break;
        }
        return value.substring(0, endIdx + 1);
    }

    private Object handleIndexOfVal(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        IndexOf locateVal = (IndexOf)value;
        String val1 = (String)this.getValue(locateVal.getVal1(), ob, params, sm);
        Val[] val2 = (Val[])this.getValue(locateVal.getVal2(), ob, params, sm);
        String strVal = (String)this.getValue(val2[0], ob, params, sm);
        int idx = ((Long)this.getValue(val2[1], ob, params, sm)).intValue();
        return strVal.indexOf(val1, idx);
    }

    private Object handleAbsVal(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        Abs absVal = (Abs)value;
        Object val = this.getValue(absVal.getValue(), ob, params, sm);
        Class<?> c = val.getClass();
        if (c == Integer.class) {
            return java.lang.Math.abs((Integer)val);
        }
        if (c == Float.class) {
            return Float.valueOf(java.lang.Math.abs(((Float)val).floatValue()));
        }
        if (c == Double.class) {
            return java.lang.Math.abs((Double)val);
        }
        if (c == Long.class) {
            return java.lang.Math.abs((Long)val);
        }
        throw new UnsupportedException();
    }

    private Object handleSqrtVal(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        Sqrt sqrtVal = (Sqrt)value;
        Object val = this.getValue(sqrtVal.getValue(), ob, params, sm);
        Class<?> c = val.getClass();
        if (c == Integer.class) {
            return java.lang.Math.sqrt(((Integer)val).doubleValue());
        }
        if (c == Float.class) {
            return java.lang.Math.sqrt(((Float)val).floatValue());
        }
        if (c == Double.class) {
            return java.lang.Math.sqrt((Double)val);
        }
        if (c == Long.class) {
            return java.lang.Math.sqrt(((Long)val).doubleValue());
        }
        throw new UnsupportedException();
    }

    private Object getValue(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        if (value instanceof PCPath) {
            FieldMapping fm = (FieldMapping)((PCPath)value).last();
            return this.getValue(ob, fm, sm);
        }
        if (value instanceof Literal) {
            return ((Literal)value).getValue();
        }
        if (value instanceof Constant) {
            return ((Constant)value).getValue(params);
        }
        return this.evaluate(value, ob, params, sm);
    }

    private Object getValue(Object ob, FieldMapping fmd, OpenJPAStateManager sm) {
        int i = fmd.getIndex();
        switch (fmd.getDeclaredTypeCode()) {
            case 0: {
                return sm.fetchBooleanField(i);
            }
            case 1: {
                return sm.fetchByteField(i);
            }
            case 2: {
                return Character.valueOf(sm.fetchCharField(i));
            }
            case 3: {
                return sm.fetchDoubleField(i);
            }
            case 4: {
                return Float.valueOf(sm.fetchFloatField(i));
            }
            case 5: {
                return sm.fetchIntField(i);
            }
            case 6: {
                return sm.fetchLongField(i);
            }
            case 7: {
                return sm.fetchShortField(i);
            }
            case 9: {
                return sm.fetchStringField(i);
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                return sm.fetchObjectField(i);
            }
        }
        throw new UnsupportedException();
    }

    public static Context[] getThreadLocalContext() {
        return (Context[])localContext.get();
    }

    public static Context getThreadLocalContext(Context orig) {
        Context[] root = (Context[])localContext.get();
        for (int i = 0; i < root.length; ++i) {
            Context lctx = JDBCStoreQuery.getThreadLocalContext(root[i], orig);
            if (lctx == null) continue;
            return lctx;
        }
        return null;
    }

    public static Select getThreadLocalSelect(Select select) {
        if (select == null) {
            return null;
        }
        Context[] lctx = JDBCStoreQuery.getThreadLocalContext();
        Context cloneFrom = select.ctx();
        for (int i = 0; i < lctx.length; ++i) {
            Context cloneTo = JDBCStoreQuery.getThreadLocalContext(lctx[i], cloneFrom);
            if (cloneTo == null) continue;
            return (Select)cloneTo.getSelect();
        }
        return select;
    }

    public static Context getThreadLocalContext(Context lctx, Context cloneFrom) {
        if (lctx.cloneFrom == cloneFrom) {
            return lctx;
        }
        List<Context> subselCtxs = lctx.getSubselContexts();
        if (subselCtxs != null) {
            for (Context subselCtx : subselCtxs) {
                Context ctx = JDBCStoreQuery.getThreadLocalContext(subselCtx, cloneFrom);
                if (ctx == null) continue;
                return ctx;
            }
        }
        return null;
    }

    private static Context[] clone(Context[] orig, Context parent) {
        Context[] newCtx = new Context[orig.length];
        for (int i = 0; i < orig.length; ++i) {
            newCtx[i] = JDBCStoreQuery.clone(orig[i], parent);
        }
        return newCtx;
    }

    private static Context clone(Context orig, Context parent) {
        Context myParent = null;
        if (parent == null) {
            Context origParent = orig.getParent();
            if (origParent != null) {
                myParent = JDBCStoreQuery.clone(orig.getParent(), null);
            }
        } else {
            myParent = parent;
        }
        Context newCtx = new Context(orig.parsed, null, myParent);
        newCtx.from = orig.from;
        newCtx.meta = orig.meta;
        newCtx.schemaAlias = orig.schemaAlias;
        newCtx.setSchemas(orig.getSchemas());
        newCtx.setVariables(orig.getVariables());
        newCtx.cloneFrom = orig;
        Object select = orig.getSelect();
        if (select != null) {
            newCtx.setSelect(((SelectImpl)select).clone(newCtx));
        }
        newCtx.subquery = orig.subquery;
        List<Context> subsels = orig.getSubselContexts();
        if (subsels != null) {
            for (Context subsel : subsels) {
                newCtx.addSubselContext(JDBCStoreQuery.clone(subsel, newCtx));
            }
        }
        return newCtx;
    }

    static {
        _listeners.put("stringContains", new JDBCStringContains());
        _listeners.put("wildcardMatch", new JDBCWildcardMatch());
        _listeners.put("sqlExp", new SQLExpression());
        _listeners.put("sqlVal", new SQLValue());
        _listeners.put("getColumn", new GetColumn());
        _listeners.put(SQLEmbed.TAG, new SQLEmbed());
        localContext = new ThreadLocalContext();
    }

    private static class ThreadLocalContext
    extends ThreadLocal<Context[]> {
        private ThreadLocalContext() {
        }

        @Override
        public Context[] initialValue() {
            return null;
        }
    }
}

