/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import org.simpleframework.http.message.Body;
import org.simpleframework.http.message.BodyConsumer;
import org.simpleframework.http.message.BufferBody;
import org.simpleframework.http.message.PartData;
import org.simpleframework.http.message.PartEntryConsumer;
import org.simpleframework.http.message.PartEntryFactory;
import org.simpleframework.http.message.PartSeries;
import org.simpleframework.transport.Cursor;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.buffer.BufferAllocator;

class PartSeriesConsumer
implements BodyConsumer {
    private PartEntryConsumer consumer;
    private PartEntryFactory factory;
    private BufferAllocator buffer;
    private PartSeries series;

    public PartSeriesConsumer(Allocator allocator, byte[] boundary) {
        this(allocator, boundary, 8192L);
    }

    public PartSeriesConsumer(Allocator allocator, byte[] boundary, long length) {
        this(allocator, new PartData(), boundary, length);
    }

    public PartSeriesConsumer(Allocator allocator, PartSeries series, byte[] boundary) {
        this(allocator, series, boundary, 8192L);
    }

    public PartSeriesConsumer(Allocator allocator, PartSeries series, byte[] boundary, long length) {
        this.buffer = new BufferAllocator(allocator, length);
        this.consumer = new PartEntryConsumer(this.buffer, series, boundary, length);
        this.factory = new PartEntryFactory(this.buffer, series, boundary, length);
        this.series = series;
    }

    public Body getBody() {
        return new BufferBody(this.buffer, this.series);
    }

    public void consume(Cursor cursor) throws IOException {
        while (cursor.isReady()) {
            if (!this.consumer.isFinished()) {
                this.consumer.consume(cursor);
                continue;
            }
            if (this.consumer.isEnd()) break;
            this.consumer = this.factory.getInstance();
        }
    }

    public boolean isFinished() {
        return this.consumer.isEnd();
    }
}

