/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import org.simpleframework.http.message.Consumer;
import org.simpleframework.transport.Cursor;

public abstract class ArrayConsumer
implements Consumer {
    protected byte[] array;
    protected int count;
    protected int chunk;
    protected boolean done;

    public ArrayConsumer() {
        this(1024);
    }

    public ArrayConsumer(int size) {
        this(size, 512);
    }

    public ArrayConsumer(int size, int chunk) {
        this.array = new byte[size];
        this.chunk = chunk;
    }

    public void consume(Cursor cursor) throws IOException {
        if (!this.done) {
            int ready = cursor.ready();
            while (ready > 0) {
                int size = Math.min(ready, this.chunk);
                if (this.count + size > this.array.length) {
                    this.resize(this.count + size);
                }
                size = cursor.read(this.array, this.count, size);
                this.count += size;
                if (size > 0) {
                    int reset = this.scan();
                    if (reset > 0) {
                        cursor.reset(reset);
                    }
                    if (this.done) {
                        this.process();
                        break;
                    }
                }
                ready = cursor.ready();
            }
        }
    }

    protected void resize(int size) throws IOException {
        if (this.array.length < size) {
            int expand = this.array.length + this.chunk;
            int max = Math.max(expand, size);
            byte[] temp = new byte[max];
            System.arraycopy(this.array, 0, temp, 0, this.count);
            this.array = temp;
        }
    }

    public boolean isFinished() {
        return this.done;
    }

    protected abstract void process() throws IOException;

    protected abstract int scan() throws IOException;
}

