/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.util.Date;
import java.util.Locale;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.Normalizer;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.lib.util.StringUtil;

public class Schemas {
    public static final Column[] EMPTY_COLUMNS = new Column[0];
    public static final ForeignKey[] EMPTY_FOREIGN_KEYS = new ForeignKey[0];
    public static final Index[] EMPTY_INDEXES = new Index[0];
    public static final Unique[] EMPTY_UNIQUES = new Unique[0];
    public static final Object[] EMPTY_VALUES = new Object[0];

    public static String getNewTableSchema(JDBCConfiguration conf) {
        return Schemas.getNewTableSchemaIdentifier(conf).getName();
    }

    public static DBIdentifier getNewTableSchemaIdentifier(JDBCConfiguration conf) {
        if (conf.getSchema() != null) {
            return DBIdentifier.newSchema(conf.getSchema());
        }
        String[] schemas = conf.getSchemasList();
        if (schemas.length == 0) {
            return DBIdentifier.NULL;
        }
        String[] names = Normalizer.splitName(schemas[0]);
        if (names.length == 0 || StringUtil.isEmpty(names[0])) {
            return DBIdentifier.NULL;
        }
        return DBIdentifier.newSchema(names[0]);
    }

    public static String getJDBCName(int type) {
        switch (type) {
            case 2003: {
                return "array";
            }
            case -5: {
                return "bigint";
            }
            case -2: {
                return "binary";
            }
            case -7: {
                return "bit";
            }
            case 2004: {
                return "blob";
            }
            case 1: {
                return "char";
            }
            case 2005: {
                return "clob";
            }
            case 91: {
                return "date";
            }
            case 3: {
                return "decimal";
            }
            case 2001: {
                return "distinct";
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 4: {
                return "integer";
            }
            case 2000: {
                return "java_object";
            }
            case -4: {
                return "longvarbinary";
            }
            case -1: {
                return "longvarchar";
            }
            case 0: {
                return "null";
            }
            case 2: {
                return "numeric";
            }
            case 1111: {
                return "other";
            }
            case 7: {
                return "real";
            }
            case 2006: {
                return "ref";
            }
            case 5: {
                return "smallint";
            }
            case 2002: {
                return "struct";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case -6: {
                return "tinyint";
            }
            case -3: {
                return "varbinary";
            }
            case 12: {
                return "varchar";
            }
        }
        return "unknown(" + type + ")";
    }

    public static int getJDBCType(String name) {
        if ("array".equalsIgnoreCase(name)) {
            return 2003;
        }
        if ("bigint".equalsIgnoreCase(name)) {
            return -5;
        }
        if ("binary".equalsIgnoreCase(name)) {
            return -2;
        }
        if ("bit".equalsIgnoreCase(name)) {
            return -7;
        }
        if ("blob".equalsIgnoreCase(name)) {
            return 2004;
        }
        if ("char".equalsIgnoreCase(name)) {
            return 1;
        }
        if ("clob".equalsIgnoreCase(name)) {
            return 2005;
        }
        if ("date".equalsIgnoreCase(name)) {
            return 91;
        }
        if ("decimal".equalsIgnoreCase(name)) {
            return 3;
        }
        if ("distinct".equalsIgnoreCase(name)) {
            return 2001;
        }
        if ("double".equalsIgnoreCase(name)) {
            return 8;
        }
        if ("float".equalsIgnoreCase(name)) {
            return 6;
        }
        if ("integer".equalsIgnoreCase(name)) {
            return 4;
        }
        if ("java_object".equalsIgnoreCase(name)) {
            return 2000;
        }
        if ("longvarbinary".equalsIgnoreCase(name)) {
            return -4;
        }
        if ("longvarchar".equalsIgnoreCase(name)) {
            return -1;
        }
        if ("null".equalsIgnoreCase(name)) {
            return 0;
        }
        if ("numeric".equalsIgnoreCase(name)) {
            return 2;
        }
        if ("other".equalsIgnoreCase(name)) {
            return 1111;
        }
        if ("real".equalsIgnoreCase(name)) {
            return 7;
        }
        if ("ref".equalsIgnoreCase(name)) {
            return 2006;
        }
        if ("smallint".equalsIgnoreCase(name)) {
            return 5;
        }
        if ("struct".equalsIgnoreCase(name)) {
            return 2002;
        }
        if ("time".equalsIgnoreCase(name)) {
            return 92;
        }
        if ("timestamp".equalsIgnoreCase(name)) {
            return 93;
        }
        if ("tinyint".equalsIgnoreCase(name)) {
            return -6;
        }
        if ("varbinary".equalsIgnoreCase(name)) {
            return -3;
        }
        if ("varchar".equalsIgnoreCase(name)) {
            return 12;
        }
        if (name == null || name.toLowerCase(Locale.ENGLISH).startsWith("unknown")) {
            return 1111;
        }
        throw new IllegalArgumentException("name = " + name);
    }

    public static Class<?> getJavaType(int type, int size, int decimals) {
        switch (type) {
            case 1: {
                if (size == 1) {
                    return Character.TYPE;
                }
            }
            case -1: 
            case 12: 
            case 2005: {
                return String.class;
            }
            case -7: {
                return Boolean.TYPE;
            }
            case -6: {
                return Byte.TYPE;
            }
            case 5: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case -5: {
                return Long.TYPE;
            }
            case 6: 
            case 7: {
                return Float.TYPE;
            }
            case 2: 
            case 8: {
                return Double.TYPE;
            }
            case 3: {
                if (decimals == 0 && size < 10) {
                    return Integer.TYPE;
                }
                if (decimals == 0) {
                    return Long.TYPE;
                }
                return Double.TYPE;
            }
            case 91: 
            case 92: 
            case 93: {
                return Date.class;
            }
        }
        return Object.class;
    }
}

