/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.connect;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.connect.SocketAgent;
import org.simpleframework.transport.connect.SocketListener;
import org.simpleframework.transport.trace.Agent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SocketListenerManager
extends HashSet<SocketListener>
implements Closeable {
    private final Server server;
    private final Agent agent;

    public SocketListenerManager(Server server, Agent agent) {
        this.agent = new SocketAgent(agent);
        this.server = server;
    }

    public SocketAddress listen(SocketAddress address) throws IOException {
        return this.listen(address, null);
    }

    public SocketAddress listen(SocketAddress address, SSLContext context) throws IOException {
        SocketListener listener = new SocketListener(address, context, this.server, this.agent);
        if (this.server != null) {
            this.add(listener);
        }
        return listener.getAddress();
    }

    @Override
    public void close() throws IOException {
        for (SocketListener listener : this) {
            listener.close();
        }
        if (this.agent != null) {
            this.agent.stop();
        }
        this.clear();
    }
}

