/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import org.simpleframework.http.ContentType;
import org.simpleframework.http.Query;
import org.simpleframework.http.Request;
import org.simpleframework.http.core.QueryCombiner;
import org.simpleframework.http.message.Entity;
import org.simpleframework.http.message.Header;

class QueryBuilder {
    private final Request request;
    private final Header header;

    public QueryBuilder(Request request, Entity entity) {
        this.header = entity.getHeader();
        this.request = request;
    }

    public Query build() {
        Query query = this.header.getQuery();
        if (!this.isFormPost()) {
            return query;
        }
        return this.getQuery(query);
    }

    private Query getQuery(Query query) {
        String body = this.getContent();
        if (body == null) {
            return query;
        }
        return new QueryCombiner(query, body);
    }

    private String getContent() {
        try {
            return this.request.getContent();
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isFormPost() {
        ContentType type = this.request.getContentType();
        if (type == null) {
            return false;
        }
        return this.isFormPost(type);
    }

    private boolean isFormPost(ContentType type) {
        String primary = type.getPrimary();
        String secondary = type.getSecondary();
        if (!primary.equals("application")) {
            return false;
        }
        return secondary.equals("x-www-form-urlencoded");
    }
}

